; Program :           DSP56002EVM Hardware Test Program
;
;           Simple serial port echo program to test wiring etc to/from
;           EVM host serial port. Every character typed on PC will be echoed
;           back to the PC and the PTT LED will flash once. The interface board
;           used was the evm56k.sch by ZS6AWK. (based on KC7WW's version)
;           Use a terminal program on PC set to 19200 baud for comms to EVM.
;           A terminal program like serial.exe (ALEFNUL) is a good choice.
;           TERM.EXE by ZS6AWK can also be used. (based on serial.c ALEFNUL)
;
;           Test commands:   M - will print back a testmessage
;                            D - will flash DCD LED (#2,x:$FFE4)
;                            S - will flash RED STATUS LED (#13,x:$FFE4)
;                            anychar - will echo and char+1 will be echo
;
;           NOTE the green heartbeat LED must flash contineously !
;           It will communicate to PC with baudrate set in BIOS.ASM ie 19200baud
;
; Author  : Danie Brynard ZS6AWK
; Email   : danie.brynard@pixie.co.za
; Packet  : zs6awk@zs6ai.tvl.zaf.af
; File    : tstsci.asm
; Update  : Sat 26/8/95
; Target  : DSP56002EVM from Motorola REV2.2
;           + KC7WW or ZS6AWK Interface board (see TAPR netsig Upload)
; Notes   : Load BIOS.ASM ver-4/95 from KC7WW before loading program
; Status  : works 99%, small error in cmd 'M'

        include 'leonid'
        org     p:user_code

        move    #0,a1      ; normal mode NOT KISS
        opensc
        move    #>'E',x0
        putc
        move    #>'V',x0
        putc
        move    #>'M',x0
        putc
        move    #>'.',x0

        ; main program loop:
loop    
                 ;jsr     <TX_MES
                 ;jmp     loop
        getc
        jsr     <chk_cmd        ; see if 'M' was pressed
        jsr     <chk_DCD        ; flash DCD LED if D pressed
        jsr     <chk_STA        ; flash status LED if S pressed
        putc                    ; echo character back
        jsr     <inc_x0
        putc
        
        bset   #0,x:$FFE4       ; toggle transmitter PTT control
        jsr    delay
        bclr   #0,x:$FFE4
        jmp     loop
        ; main loop end here

inc_x0  move    #>1,a           ; increment x0 by 1
        add     x0,a
        move    a,x0
        rts

delay   do      #500,_d_loop    ; create a 50ms delay
	rep     #2000           ; 100 us delay
	nop
_d_loop
        rts

; Subroutine to check for 'D' cmd and flash DCD:
chk_DCD  move    #>'D',a
         cmp     x0,a
         jne     <_dcd_end
         jsr     <flashdcd
_dcd_end rts
flashdcd bset   #2,x:$FFE4       ; toggle DCD LED
         jsr    delay
         bclr   #2,x:$FFE4
         rts

; Subroutine to check for 'S' cmd and flash status LED:
chk_STA  move    #>'S',a
         cmp     x0,a
         jne     <_sta_end
         jsr     <flashsta
_sta_end rts
flashsta bset   #13,x:$FFE4       ; toggle status LED
         jsr    delay
         bclr   #13,x:$FFE4
         rts

; Check for 'M' cmd and print then message:
chk_cmd  move    #>'M',a
         cmp     x0,a
         jne     <_chk_end
         jsr     <TX_MES
_chk_end rts

TX_MES   move    #>TABLE,r0   ; send message to terminal
         DO      #(E_TABLE-TABLE),_TX_MES
          move     p:(r0),a1   ;p:(r0) points to a 24bit memory address
          rep      #16
          ror      a1
          move     a1,x0
          putc                 ;send first character
          move     p:(r0),a1
          rep      #8
          ror      a1
          move     a1,x0
          putc                 ;send 2nd character
          move     p:(r0)+,a1  ;increment r0 pointer
          move     a1,x0
          putc                 ;send 3rd character
          nop
_TX_MES   nop
         rts

        org P:*   ;put data in program memory
; sign on message
TABLE   DC      'ABCDEF TEST MESSAGE [tstsci.asm] 0123456789'
        DC      $0D
        DC      $0A
E_TABLE
        end
